/**
 *
 * \file        hprfgw_rfslaveintftorfapp.h
 *
 * \brief       The RF slave device interface to rf application		
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        11/28/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFSLAVEINTTORFAPP_H_
    #define _HPRFGW_RFSLAVEINTTORFAPP_H_

#include "hprfgw_config.h"
//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfApp.h"

////////////////////////////////////////////////////////////////////////////////
//	Definitions
////////////////////////////////////////////////////////////////////////////////
#define VALID_UID_SIGNATURE		0xA55A3786

////////////////////////////////////////////////////////////////////////////////
//	Data Prototypes	
////////////////////////////////////////////////////////////////////////////////
typedef	struct {
    void	(*pF_InitRFApplication) (void); 
    void	(*pF_SetGatewayUID_PANID_ADDRMODE) (BOOL Valid, UINT8 *pUID, UINT16 PanID, UINT8 AddrMode);
    void	(*pF_SetLocaldeviceUID_PANID)(BOOL Valid, UINT8 *pUID, UINT16 PanID);
    UINT16	(*pF_PostCresnetPacket) (UINT8 *pBuf, UINT16 BufLen, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
    UINT16	(*pF_DisconnectDeviceFromNetwork) (void);
    UINT16	(*pF_ConnectDeviceToNetwork) (UINT8 *pgatewayuid, UINT16 gatewaypanid, UINT8 channel, UINT8 gatewayaddrmode);	
    UINT16	(*pF_LookupSettingsAndConnectDeviceToNetwork) (void);	
    UINT16	(*pF_EnterSleepMode) (void);
    UINT16	(*pF_EnterPowerDownMode) (void);
    UINT16	(*pF_PostLocalCresnetPacket) (UINT8 *pBuf, UINT16 BufLen, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
    BOOL	(*pF_ControlSystemConnectionStatusQuery) (void);
    BOOL	(*pF_GatewayConnectionStatusQuery) (void);
    UINT16	(*pF_AcquireStart) (UINT32 timeout);
    UINT16	(*pF_AcquireStop) (BOOL ReStartNetwork);
    BOOL	(*pF_AcquireStatus) (void);
    void	(*pF_SetRetryCount) (UINT8 RetryCnt);
    void	(*pF_SetRetryDelay) (UINT8 *RetryDly, UINT8 Cnt, UINT8 Index);
    void	(*pF_SetPowerLevel) (UINT16 PowerLevel);
    void	(*pF_SetChannel) (UINT8 Channel);	
    void	(*pF_SetCCAEnergyDetectThr) (UINT8 CCAEnergyDetectThr);
    void	(*pF_SetRSSIPowerCompOffset) (UINT8 RSSIPowerCompOffset);
    void	(*pF_SetResultCodeTimeout) (UINT16 ResultCodeTimeout);
    void	(*pF_SetIDString) (UINT8 rfid, UINT32 tsid, UINT8 *pIDStr);
    UINT16	(*pF_ResetRFTransmitBuffers) (void);
    INT32	(*pF_SetDeviceDataField) (UINT8 field, INT8 *pbuf, UINT16 len);
    INT32	(*pF_PrepareAndPostDeviceDataInfoStr) (UINT8 field);
    INT32	(*pF_PostEchoPacketRequest) (TYPE_RF_ECHO_REQUEST_PACKET *pEchoRequest);
    UINT16	(*pF_ConvertLQIToIEEEScaleWord) (UINT8 LQI, INT8 offset);
    INT32	(*pF_ConvertLQITodBm) (UINT8 LQI);
    INT32	(*pF_GetLQI) (UINT8 RFID, BOOL LocalDevice, UINT8 *plinkquality);
    float	(*pF_ConvertPowerTodBm) (UINT16 power, BOOL Translate);
    UINT16	(*pF_RFReceive_GetLocalDevicePower) (void);
    INT32	(*pF_GoingToStandBy) (void);
    INT32	(*pF_ComingoutofStandBy) (void);
    INT32	(*pF_NetworkService) (TYPE_RF_DISCOVER_REQUEST *pdisc);
    INT32	(*pF_SetRetryCountOnConnectionReq) (UINT8 retrycount);
    INT32	(*pF_SetPreLinkQueryPacketCnt) (UINT8 count);	
    INT32	(*pF_PostCresnetPacketByRFID) (UINT8 rfid, UINT8 *pBuf, UINT16 BufLen, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
    INT32	(*pF_PostLocalCresnetPacketByRFID) (UINT8 rfid, UINT8 *pBuf, UINT16 BufLen, UINT8 priority, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
    UINT16	(*pF_PowerDown) (void);
    UINT16	(*pF_PowerUp) (void);
}	TYPE_INTERFACE_TO_RFAPP_APP; 
extern const TYPE_INTERFACE_TO_RFAPP_APP RFIntRFApp;

////////////////////////////////////////////////////////////////////////////////
//	Function declarations
////////////////////////////////////////////////////////////////////////////////
void RFAPP_ClearDiagCounters(void);

#endif
/**/
